﻿using System;
using System.Reflection;
using Microsoft.SharePoint;

namespace OpenWeb
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb("blog"))
            {
               web.Title = "Mein SharePoint Blog";
               web.Description = "Das ist mein persönlicher Blog";
               web.SiteLogoUrl = String.Format(web.Url,
                  "/_layouts/images/myLogo.png");

               // Änderungen übernehmen
               web.Update();
            }
         }
      }

      #region GetMethods HIDE

      static void GetMethods()
      {
         Console.WriteLine("Collection-Eigenschaften der SPWeb-Klasse:\n");
         Type t = typeof(SPWeb);

         PropertyInfo[] properties = t.GetProperties();

         Array.Sort(properties,
            delegate(PropertyInfo propertyInfo1, PropertyInfo propertyInfo2)
            {
               return propertyInfo1.Name.CompareTo(propertyInfo2.Name);
            });

         foreach (PropertyInfo p in properties)
         {
            // Type myType = p.PropertyType;
            TypeFilter myFilter = new TypeFilter(InterfaceFilter);
            String[] myInterfaceList = new String[1] { "System.Collections.ICollection" };
            Type[] myInterfaces = p.PropertyType.FindInterfaces(myFilter, myInterfaceList[0]);

            if (myInterfaces.Length > 0)
            {
               Console.WriteLine("> {0}  ({1})", p.Name, p.PropertyType.Name);
            }
         }
      }

      static bool InterfaceFilter(Type typeObj, Object criteriaObj)
      {
         if (typeObj.ToString() == criteriaObj.ToString())
            return true;
         else
            return false;
      }

      #endregion
   }
}